<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\events;

use app\util\SMTDto;

class SMTMessageDto extends SMTDto
{    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\events\SMTEventDto')
     * @var app\events\SMTEventDto
     */
    protected $event = NULL;

    /**
     * Message destinator
     * 
     * @var string
     */
    protected $consumerId;
    
    public function setConsumerId( $consumerId )
    {
    	$this->consumerId = $consumerId;
    }
    
    public function getConsumerId()
    {
    	return $this->consumerId;
    }        

    public function setEvent( SMTEventDto $event )
    {       
        $this->event = $event;
    }
    
    public function getEvent()
    {
    	return $this->event;
    }    

    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dto class name
     */
    public function getDtoClassName()
    {
    	return get_class();
    }
} 

?>